#include "stdafx.h"
#include "R-HH-M3O-LF-SDK.h"
#include "TransportSerial.h"
#include "SoltecLFProt.h"

#include "Utility.h"

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
	switch (ul_reason_for_call)
	{
	case DLL_PROCESS_ATTACH:
	case DLL_THREAD_ATTACH:
	case DLL_THREAD_DETACH:
	case DLL_PROCESS_DETACH:
		break;
	}
    return TRUE;
}

SDKHANDLE OpenReader()
{
	CSoltecLFProtocol *pLFReader = new CSoltecLFProtocol();
	if(pLFReader != NULL)
	{
		pLFReader->SetCom(0x01);
		EERROR eRet = pLFReader->Open();
		if(eRet != ER_OK)
		{
			delete pLFReader;
			pLFReader = NULL;
		}
	}
	return pLFReader;
}

EERROR GetReaderCaps(SDKHANDLE hReader, EREADER_FEATURE eRdFeat, BYTE* pData, DWORD& dwData)
{
	EERROR eRet = ER_INVALID_POINTER;
	CSoltecLFProtocol *pLFReader = (CSoltecLFProtocol*)hReader;
	if((pLFReader != NULL) && (pData != NULL))
	{
		switch(eRdFeat)
		{
			case ERD_VERSION:
			{
				eRet = pLFReader->GetVersion(pData, dwData);
			}break;

			case ERD_SERIAL_NUMBER:
			{
				eRet = pLFReader->GetSerialNr(pData, dwData);
			}break;

			case ERD_SCAN_CARD:
			{
				eRet = pLFReader->ScanCard(pData, dwData);
			}break;
		}
	}
	return eRet;
}


EERROR SetReaderCaps(SDKHANDLE hReader, EREADER_FEATURE eRdFeat, BYTE* pData, DWORD dwData)
{
	EERROR eRet = ER_INVALID_POINTER;
	CSoltecLFProtocol *pLFReader = (CSoltecLFProtocol*)hReader;
	if(pLFReader != NULL)
	{
		switch(eRdFeat)
		{
			case ERD_RESET:
			{
				eRet = pLFReader->Reset();
			}break;

			case ERD_SET_LED:
			{
				if(pData != NULL)
				{
					eRet = pLFReader->SetLed(pData[0x00]);
				}
			}break;

			case ERD_TURNOFF_CONT_MODE:
			{
				eRet = pLFReader->TurnOffContMode();
			}break;


			case ERD_START_BLOCK:
			{
				eRet = ER_INVALID_DATA;
				if(pData != NULL)
				{
					pLFReader->SetStartBlock(*(DWORD*)pData);
					eRet = ER_OK;
				}
			}break;

			case ERD_LOGIN:
			{
				eRet = ER_INVALID_DATA;
				if(pData != NULL)
				{
					eRet = pLFReader->Login(pData, dwData);
				}
			}break;
		}
	}
	return eRet;
}

EERROR ReadData(SDKHANDLE hReader, BYTE* pData, DWORD& dwData)
{
	EERROR eRet = ER_INVALID_POINTER;
	CSoltecLFProtocol *pLFReader = (CSoltecLFProtocol*)hReader;
	if(pLFReader != NULL)
	{
		BYTE pDataRead[0x10]; DWORD dwDataRead = 0x10;
		if((eRet = pLFReader->Read(pDataRead, dwDataRead)) == ER_OK)
		{
			eRet = ER_READ;
			if(dwDataRead >= 0x02)
			{
				BYTE* pDataRet = NULL; DWORD dwDataRet = 0x00;
				CUtility::HexToByte(pDataRead, dwDataRead, &pDataRet, dwDataRet);
				eRet = CUtility::SetDataByte(pDataRet, dwDataRet, pData, dwData);

				delete[] pDataRet; pDataRet = NULL;
			}
		}
	}

	return eRet;
}

EERROR WriteData(SDKHANDLE hReader, BYTE* pData, DWORD dwData)
{
	EERROR eRet = ER_INVALID_POINTER;
	CSoltecLFProtocol *pLFReader = (CSoltecLFProtocol*)hReader;
	if(pLFReader != NULL)
	{
		eRet = pLFReader->Write(pData, dwData);
	}
	return eRet;
}

void CloseReader(SDKHANDLE hReader)
{
	CSoltecLFProtocol *pLFReader = (CSoltecLFProtocol*)hReader;
	if(pLFReader != NULL)
	{
		pLFReader->Close();
		delete pLFReader;
	}
}
